/*
 * Decompiled with CFR 0.152.
 */
package com.djinfinite.manors_bounty.client;

import com.djinfinite.manors_bounty.client.CustomTooltipPositioner;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageWidget;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class RenderedImage
extends ImageWidget {
    private final ResourceLocation[] textures;
    private float rotateAngle = 0.0f;
    private int index = 0;
    private int cycleTick = 20;
    private int currentTick = 0;
    private float minU = 0.0f;
    private float maxU = 1.0f;
    private float minV = 0.0f;
    private float maxV = 1.0f;

    public RenderedImage(ResourceLocation ... textures) {
        this(0, 0, textures[0]);
    }

    public RenderedImage(int w, int h, ResourceLocation ... textures) {
        this(0, 0, w, h, textures[0]);
    }

    public RenderedImage(int x, int y, int w, int h, ResourceLocation ... textures) {
        super(x, y, w, h, textures[0]);
        this.textures = textures;
    }

    public float getMaxU() {
        return this.maxU;
    }

    public void setMaxU(float maxU) {
        this.maxU = maxU;
    }

    public float getMaxV() {
        return this.maxV;
    }

    public void setMaxV(float maxV) {
        this.maxV = maxV;
    }

    public float getMinU() {
        return this.minU;
    }

    public void setMinU(float minU) {
        this.minU = minU;
    }

    public float getMinV() {
        return this.minV;
    }

    public void setMinV(float minV) {
        this.minV = minV;
    }

    public ResourceLocation currentTexture() {
        return this.textures[this.index];
    }

    public void nextTexture() {
        this.index = this.index < this.textures.length - 1 ? ++this.index : 0;
    }

    public void prevTexture() {
        this.index = this.index > 0 ? --this.index : this.textures.length - 1;
    }

    public int getCycleTick() {
        return this.cycleTick;
    }

    public void setCycleTick(int cycleTick) {
        this.cycleTick = cycleTick;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public void setCurrentTick(int currentTick) {
        this.currentTick = currentTick;
    }

    public void guiTick() {
        if (this.currentTick == this.cycleTick) {
            this.nextTexture();
            this.currentTick = 0;
        } else {
            ++this.currentTick;
        }
    }

    public void setRotate(float angle) {
        this.rotateAngle = (float)Math.toRadians(angle);
    }

    public void rotate(float angle) {
        this.rotateAngle += (float)Math.toRadians(angle);
    }

    @NotNull
    protected ClientTooltipPositioner m_262860_() {
        return new CustomTooltipPositioner();
    }

    public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderImage(pGuiGraphics);
    }

    public void renderImage(GuiGraphics guiGraphics) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.currentTexture());
        RenderSystem.setShader(GameRenderer::m_172817_);
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)guiGraphics.m_280168_().m_85850_().m_252922_());
        float centerX = (float)this.m_252754_() + (float)this.m_5711_() / 2.0f;
        float centerY = (float)this.m_252907_() + (float)this.m_93694_() / 2.0f;
        if (this.rotateAngle != 0.0f) {
            Matrix4f translationMatrix = new Matrix4f().translate(centerX, centerY, 0.0f);
            Matrix4f rotationMatrix = new Matrix4f().rotate(this.rotateAngle, 0.0f, 0.0f, 1.0f);
            translationMatrix.mul((Matrix4fc)rotationMatrix);
            Matrix4f inverseTranslationMatrix = new Matrix4f().translate(-centerX, -centerY, 0.0f);
            translationMatrix.mul((Matrix4fc)inverseTranslationMatrix);
            matrix4f.mul((Matrix4fc)translationMatrix);
        }
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, (float)this.m_252754_(), (float)this.m_252907_(), 0.0f).m_7421_(this.minU, this.minV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)this.m_252754_(), (float)(this.m_252907_() + this.m_93694_()), 0.0f).m_7421_(this.minU, this.maxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)(this.m_252754_() + this.m_5711_()), (float)(this.m_252907_() + this.m_93694_()), 0.0f).m_7421_(this.maxU, this.maxV).m_5752_();
        bufferbuilder.m_252986_(matrix4f, (float)(this.m_252754_() + this.m_5711_()), (float)this.m_252907_(), 0.0f).m_7421_(this.maxU, this.minV).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }
}

